// WorkerThreadRemote - object to process and manage jobs on a remote thread
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_WORKERTHREADREMOTE_H
#define FBUILD_WORKERTHREADREMOTE_H

// Includes
//------------------------------------------------------------------------------
#include "WorkerThread.h"
#include "Core/Process/Mutex.h"

// Forward Declarations
//------------------------------------------------------------------------------
class Job;

// WorkerThread
//------------------------------------------------------------------------------
class WorkerThreadRemote : public WorkerThread
{
public:
	WorkerThreadRemote( uint32_t threadIndex );
	virtual ~WorkerThreadRemote();

	void GetStatus( AString & status ) const;
private:
	virtual void Main();
	
	mutable Mutex m_CurrentJobMutex;
	Job * m_CurrentJob;
};

//------------------------------------------------------------------------------
#endif // FBUILD_WORKERTHREADREMOTE_H 