// WorkerThreadRemote
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "WorkerThreadRemote.h"
#include "Job.h"

#include "Tools/FBuild/FBuildCore/FBuild.h"
#include "Tools/FBuild/FBuildCore/FLog.h"
#include "Tools/FBuild/FBuildCore/WorkerPool/JobQueueRemote.h"

#include "Core/Process/Thread.h"
#include "Core/Time/Timer.h"

// Static
//------------------------------------------------------------------------------
static AString g_IdleString( "Idle" );

//------------------------------------------------------------------------------
WorkerThreadRemote::WorkerThreadRemote( uint32_t threadIndex )
: WorkerThread( threadIndex )
, m_CurrentJob( nullptr )
{
}

//------------------------------------------------------------------------------
WorkerThreadRemote::~WorkerThreadRemote()
{
}

// Main
//------------------------------------------------------------------------------
/*virtual*/ void WorkerThreadRemote::Main()
{
	while ( m_ShouldExit == false )
	{
		// try to find some work to do
		Job * job = JobQueueRemote::Get().GetJobToProcess();
		if ( job != nullptr )
		{
			{
				MutexHolder mh( m_CurrentJobMutex );
				m_CurrentJob = job;
			}

			// process the work
			Node::BuildResult result = JobQueueRemote::DoBuild( job );
			ASSERT( ( result == Node::NODE_RESULT_OK ) || ( result == Node::NODE_RESULT_FAILED ) );

			{
				MutexHolder mh( m_CurrentJobMutex );
				m_CurrentJob = nullptr;
			}

			JobQueueRemote::Get().FinishedProcessingJob( job, ( result != Node::NODE_RESULT_FAILED ) );

			// loop again to get another job
			continue;
		}

		// no work to do right now
		Thread::Sleep( 1 ); // wait and try again later
	}

	m_Exited = true;
}

// GetStatus
//------------------------------------------------------------------------------
void WorkerThreadRemote::GetStatus( AString & status ) const
{
	MutexHolder mh( m_CurrentJobMutex );
	status = ( m_CurrentJob == nullptr ) ? g_IdleString
										 : m_CurrentJob->GetNode()->GetName();
}

//------------------------------------------------------------------------------
