// Job
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "Job.h"

#include "Tools/FBuild/FBuildCore/Graph/Node.h"
#include "Tools/FBuild/FBuildCore/Helpers/Compressor.h"

#include "Core/Env/Assert.h"
#include "Core/FileIO/IOStream.h"
#include "Core/Strings/AStackString.h"

#include "windows.h" // for InterlockedIncrement

// Static
//------------------------------------------------------------------------------
static uint32_t s_LastJobId( 0 );

// CONSTRUCTOR
//------------------------------------------------------------------------------
Job::Job( Node * node ) 
	: m_Next( nullptr )
	, m_Node( node )
	, m_Data( nullptr )
	, m_DataSize( 0 ) 
	, m_UserData( nullptr )
	, m_DataIsCompressed( false )
	, m_IsLocal( true )
{
	m_JobId = InterlockedIncrement( &s_LastJobId );
}

// CONSTRUCTOR
//------------------------------------------------------------------------------
Job::Job( IOStream & stream ) 
	: m_Next( nullptr )
	, m_Node( nullptr )
	, m_Data( nullptr )
	, m_DataSize( 0 ) 
	, m_UserData( nullptr )
	, m_IsLocal( false )
{
	Deserialize( stream );
}

// DESTRUCTOR
//------------------------------------------------------------------------------
Job::~Job()
{
	::Free( m_Data );
}

// OwnData
//------------------------------------------------------------------------------
void Job::OwnData( void * data, size_t size, bool compressed )
{
	::Free( m_Data );

	ASSERT( size <= 0xFFFFFFFF ); // only 32bit data supported

	m_Data = data;
	m_DataSize = (uint32_t)size;
	m_DataIsCompressed = compressed;
}

// Serialize
//------------------------------------------------------------------------------
void Job::Serialize( IOStream & stream )
{
	// write jobid
	stream.Write( m_JobId );

	// write properties of node
	Node::Save( stream, m_Node, true );

	stream.Write( IsDataCompressed() );

	stream.Write( m_DataSize );
	stream.Write( m_Data, m_DataSize );
}

// Deserialize
//------------------------------------------------------------------------------
void Job::Deserialize( IOStream & stream )
{
	// read jobid
	stream.Read( m_JobId );

	// read properties of node
	m_Node = Node::Load( stream, true );

	bool compressed;
	stream.Read( compressed );

	// read extra data
	uint32_t dataSize;
	stream.Read( dataSize );
	void * data = ::Alloc( dataSize );
	stream.Read( data, dataSize );

	OwnData( data, dataSize, compressed );
}

//------------------------------------------------------------------------------
