// VSProjectGenerator - Generate a Visual Studio project
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_HELPERS_VSPROJECTGENERATOR_H
#define FBUILD_HELPERS_VSPROJECTGENERATOR_H

// Includes
//------------------------------------------------------------------------------
#include "Core/Containers/Array.h"
#include "Core/Strings/AString.h"

// Forward Declarations
//------------------------------------------------------------------------------

// VSProjectGenerator
//------------------------------------------------------------------------------
class VSProjectGenerator
{
public:
	VSProjectGenerator();
	~VSProjectGenerator();

	void SetProjectName( const AString & name ) { m_ProjectName = name; }
	void SetBasePath( const AString & path );
	void SetAllowedFileExtensions( Array< AString > & extensions ) { m_AllowedFileExtensions = extensions; }

	void AddFile( const AString & file, bool filterByExtension = true );
	void AddFiles( const Array< AString > & files, bool filterByExtension = true );
	void AddPlatform( const AString & platform );
	void AddConfig( const AString & config );

	void SetBuildCommand( const AString & command )		{ m_BuildCommand = command; }
	void SetRebuildCommand( const AString & command )	{ m_RebuildCommand = command; }
	void SetCleanCommand( const AString & command )		{ m_CleanCommand = command; }

	void SetLocalDebuggerCommandArguments( const AString & s )	{ m_LocalDebuggerCommandArguments = s; }
	void SetLocalDebuggerWorkingDirectory( const AString & s )	{ m_LocalDebuggerWorkingDirectory = s; }
	void SetLocalDebuggerCommand( const AString & s )			{ m_LocalDebuggerCommand = s; }
	void SetLocalDebuggerEnvironment( const AString & s )		{ m_LocalDebuggerEnvironment = s; }

	void SetIntDir( const AString & dir ) { m_IntDir = dir; }
	void SetOutDir( const AString & dir ) { m_OutDir = dir; }

	const AString & GenerateVCXProj();
	const AString & GenerateVCXProjFilters();

private:
	// Helper to format some text
	void Write( const char * fmtString, ... );

	// project details
	AString m_ProjectName;
	AString m_BasePath;
	Array< AString > m_AllowedFileExtensions;

	// intermediate data
	Array< AString > m_Files;
	Array< AString > m_Platforms;
	Array< AString > m_Configs;

	// commands
	AString m_BuildCommand;
	AString m_RebuildCommand;
	AString m_CleanCommand;

	// debugger options
	AString m_LocalDebuggerCommandArguments;
	AString m_LocalDebuggerWorkingDirectory;
	AString m_LocalDebuggerCommand;
	AString m_LocalDebuggerEnvironment;

	// folders
	AString m_IntDir;
	AString m_OutDir;

	// working buffer
	AString m_Tmp;

	// final output
	AString m_OutputVCXProj;
	AString m_OutputVCXProjFilters;
};

//------------------------------------------------------------------------------
#endif // FBUILD_HELPERS_VSPROJECTGENERATOR_H
