// ToolManifest
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_HELPERS_TOOLMANIFEST_H
#define FBUILD_HELPERS_TOOLMANIFEST_H

// Forward Declarations
//------------------------------------------------------------------------------
class MemoryStream;
class Node;

// Includes
//------------------------------------------------------------------------------
#include "Core/Env/Types.h"
#include "Core/Strings/AString.h"

// ToolManifest
//------------------------------------------------------------------------------
class ToolManifest
{
public:
	explicit ToolManifest();
	~ToolManifest();

	void Generate( const Array< Node * > & dependencies );

	inline uint32_t GetToolId() const { return m_ToolId; }

	void Serialize( MemoryStream & ms ) const;

	// operator for FindDeref
	inline bool operator == ( uint32_t toolId ) const
	{
		return ( m_ToolId == toolId );
	}

private:
	uint32_t			m_ToolId;	// Globally identifier for this toolchain
	Array< Node * >		m_Nodes;	// Files comprising this toolchain
};

//------------------------------------------------------------------------------
#endif // FBUILD_HELPERS_TOOLMANIFEST_H
