// ToolManifest
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "ToolManifest.h"
#include "Core/FileIO/MemoryStream.h"
#include "Core/Math/CRC32.h"
#include "Tools/FBuild/FBuildCore/Graph/FileNode.h"

// CONSTRUCTOR
//------------------------------------------------------------------------------
ToolManifest::ToolManifest()
	: m_Nodes( 0, true )
{
}

// DESTRUCTOR
//------------------------------------------------------------------------------
ToolManifest::~ToolManifest()
{
}

// Generate
//------------------------------------------------------------------------------
void ToolManifest::Generate( const Array< Node * > & dependencies )
{
	ASSERT( m_Nodes.IsEmpty() );
	ASSERT( !dependencies.IsEmpty() );

	// keep a copy for future use
	m_Nodes = dependencies; // TODO:C This could probably safely be a pointer.

	// create a hash for the whole tool chain
	uint32_t toolId = CRC32::Start();
	const size_t numDeps( dependencies.GetSize() );
	for ( size_t i=0; i<numDeps; ++i )
	{
		const FileNode & n = *( m_Nodes[ i ]->CastTo< FileNode >() );

		// user must have ensure nodes are updated
		ASSERT( n.GetState() == Node::UP_TO_DATE );

		const AString & name( n.GetName() );
		const uint64_t timeStamp( n.GetStamp() );
		toolId = CRC32::Update( toolId, name.Get(), name.GetLength() );
		toolId = CRC32::Update( toolId, &timeStamp, sizeof( timeStamp ) );
	}
	m_ToolId = CRC32::Stop( toolId );
}

// Serialize
//------------------------------------------------------------------------------
void ToolManifest::Serialize( MemoryStream & ms ) const
{
	const uint32_t numItems( (uint32_t)m_Nodes.GetSize() );
	ms.Write( numItems );
	for ( size_t i=0; i<(size_t)numItems; ++i )
	{
		const FileNode & n = *( m_Nodes[ i ]->CastTo< FileNode >() );
		const AString & name( n.GetName() );
		const uint64_t timeStamp( n.GetStamp() );
		ms.Write( name );
		ms.Write( timeStamp );
	}
}

//------------------------------------------------------------------------------
