// ResponseFile
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "ResponseFile.h"

// FBuild
#include "Tools/FBuild/FBuildCore/WorkerPool/WorkerThread.h"
#include "Tools/FBuild/FBuildCore/Flog.h"

// Core
#include "Core/FileIO/FileIO.h"

// CONSTRUCTOR
//------------------------------------------------------------------------------
ResponseFile::ResponseFile()
{
}

// DESTRUCTOR
//------------------------------------------------------------------------------
ResponseFile::~ResponseFile()
{
	FileIO::FileDelete( m_ResponseFilePath.Get() );
}

// Generate
//------------------------------------------------------------------------------
bool ResponseFile::Create( const AString & contents )
{
	// store in tmp folder, and give back to user
	WorkerThread::CreateTempFilePath( "rsp", m_ResponseFilePath );

	// write file to disk
	const uint32_t flags = FileStream::WRITE_ONLY		// we only want to write
						 | FileStream::TEMP;			// avoid flush to disk if possible
	if ( !m_File.Open( m_ResponseFilePath.Get(), flags ) )
	{
		FLOG_ERROR( "Failed to create response file '%s'", m_ResponseFilePath.Get() );
		return false; // user must handle error
	}

	bool ok = ( m_File.Write( contents.Get(), contents.GetLength() ) == contents.GetLength() );
	if ( !ok )
	{
		FLOG_ERROR( "Failed to write response file '%s'", m_ResponseFilePath.Get() );
	}

	m_File.Close(); // must be closed so MSVC link.exe can open it

	return ok;
}

//------------------------------------------------------------------------------
