// CIncludeParser - Parse a c, cpp or h file and return all included headers
//                  recursively.
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_HELPERS_CINCLUDEPARSER_H
#define FBUILD_HELPERS_CINCLUDEPARSER_H

// Includes
//------------------------------------------------------------------------------
#include "Core/Containers/Array.h"
#include "Core/Strings/AString.h"

// CIncludeParser class
//------------------------------------------------------------------------------
class CIncludeParser
{
public:
	explicit CIncludeParser();
	~CIncludeParser();

	bool ParseMSCL_Output( const char * compilerOutput, size_t compilerOutputSize );
	bool ParseMSCL_Preprocessed( const char * compilerOutput, size_t compilerOutputSize );
	bool ParseGCC_Preprocessed( const char * compilerOutput, size_t compilerOutputSize );

	const Array< AString > & GetIncludes() const { return m_Includes; }

	// take ownership of includes array to avoid re-allocations
	void SwapIncludes( Array< AString > & includes );
	inline size_t GetNonUniqueCount() const { return m_NonUniqueCount; }

private:
	bool Parse( const char * compilerOutput,
				size_t compilerOutputSize,
				const char * startOfLineString,
				bool quoted );

	static inline void SkipWhitespace( const char * & pos, const char * end );
	static inline void SkipToEndOfLine( const char * & pos, const char * end );

	Array< AString > m_Includes;	// list of unique includes
	size_t m_NonUniqueCount;		// number of include directives seen
};

//------------------------------------------------------------------------------
#endif // FBUILD_HELPERS_CINCLUDEPARSER_H 