// VCXProjectNode.h - a node that builds a vcxproj file
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_GRAPH_VCXPROJECTNODE_H
#define FBUILD_GRAPH_VCXPROJECTNODE_H

// Includes
//------------------------------------------------------------------------------
#include "FileNode.h"
#include "Core/Containers/Array.h"
#include "Core/FileIO/FileIO.h"
#include "Core/Strings/AString.h"

// Forward Declarations
//------------------------------------------------------------------------------
class DirectoryListNode;
class VSProjectGenerator;

// UnityNode
//------------------------------------------------------------------------------
class VCXProjectNode : public Node
{
public:
	explicit VCXProjectNode( const AString & projectOutput,
							 const AString & projectBasePath,
							 const Array< DirectoryListNode * > & paths,
							 const Array< AString > & pathsToExclude,
							 const Array< AString > & allowedFileExtensions,
							 const Array< AString > & files,
							 const Array< AString > & filesToExclude,
							 const Array< AString > & configs,
							 const Array< AString > & platforms,
							 const AString & buildCmd,
							 const AString & rebuildCmd,
							 const AString & cleanCmd,
							 const AString & localDebuggerCommandArguments,
							 const AString & localDebuggerWorkingDirectory,
							 const AString & localDebuggerCommand,
							 const AString & localDebuggerEnvironment );
	virtual ~VCXProjectNode();

	static inline Node::Type GetType() { return Node::VCXPROJECT_NODE; }

	static Node * Load( IOStream & stream, bool remote );
	virtual bool Save( IOStream & stream, bool remote ) const;
private:
	virtual BuildResult DoBuild( Job * job );

	virtual bool IsAFile() const { return false; } // TODO: Check this

	bool Save( const AString & content, const AString & fileName ) const;

	// TODO: Move into base class (share with UnityNode)
	void GetFiles( Array< FileIO::FileInfo * > & files ) const;

	void AddFile( VSProjectGenerator & pg, const AString & fileName ) const;

	AString				m_ProjectBasePath;
	Array< AString >	m_PathsToExclude;
	Array< AString >	m_AllowedFileExtensions;
	Array< AString >	m_Files;
	Array< AString >	m_FilesToExclude;
	Array< AString >	m_Configs;
	Array< AString >	m_Platforms;
	AString				m_BuildCommand;
	AString				m_RebuildCommand;
	AString				m_CleanCommand;
	AString				m_LocalDebuggerCommandArguments;
	AString				m_LocalDebuggerWorkingDirectory;
	AString				m_LocalDebuggerCommand;
	AString				m_LocalDebuggerEnvironment;
};

//------------------------------------------------------------------------------
#endif // FBUILD_GRAPH_VCXPROJECTNODE_H
