// ObjectListNode.h - manages a list of ObjectNodes
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_GRAPH_OBJECTLISTNODE_H
#define FBUILD_GRAPH_OBJECTLISTNODE_H

// Includes
//------------------------------------------------------------------------------
#include "Node.h"
#include "Core/Containers/Array.h"

// Forward Declarations
//------------------------------------------------------------------------------
class ObjectNode;

// ObjectListNode
//------------------------------------------------------------------------------
class ObjectListNode : public Node
{
public:
	explicit ObjectListNode( const AString & listName,
							 const Array< Node * > & inputNodes,
							 FileNode * compiler,
							 const AString & compilerArgs,
							 const AString & compilerOutputPath,
							 ObjectNode * precompiledHeader,
							 const Array< Node * > & compilerForceUsing,
							 const Array< Node * > & preBuildDependencies );
	virtual ~ObjectListNode();

	static inline Node::Type GetType() { return Node::OBJECT_LIST_NODE; }

	virtual bool IsAFile() const;

	static Node * Load( IOStream & stream, bool remote );
	virtual bool Save( IOStream & stream, bool remote ) const;

	const char * GetObjExtension() const;

	void GetInputFiles( AString & fullArgs, const AString & pre, const AString & post ) const;
private:
	friend class FunctionObjectList;

	virtual bool DoDynamicDependencies( bool forceClean );
	virtual BuildResult DoBuild( Job * job );

	// internal helpers
	bool CreateDynamicObjectNode( Node * inputFile );

	FileNode *		m_Compiler;
	AString			m_CompilerArgs;
	AString			m_CompilerOutputPath;
	Array< Node * > m_CompilerForceUsing;
	ObjectNode *	m_PrecompiledHeader;
	uint32_t		m_Flags;
	AString			m_ObjExtensionOverride;
};

//------------------------------------------------------------------------------
#endif // FBUILD_GRAPH_OBJECTNODE_H
