// LibraryNode.h - a node that builds a single object from a source file
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_GRAPH_LIBRARYNODE_H
#define FBUILD_GRAPH_LIBRARYNODE_H

// Includes
//------------------------------------------------------------------------------
#include "FileNode.h"
#include "Core/Containers/Array.h"

// Forward Declarations
//------------------------------------------------------------------------------
class ObjectNode;

// LibraryNode
//------------------------------------------------------------------------------
class LibraryNode : public FileNode
{
public:
	explicit LibraryNode( const AString & libraryName,
						  Array< Node * > & inputNodes,
						  FileNode * compiler,
						  const AString & compilerArgs,
						  const AString & compilerOutputPath,
						  const AString & librarian,
						  const AString & librarianArgs,
						  ObjectNode * precompiledHeader,
						  const Array< Node * > & compilerForceUsing,
						  const Array< Node * > & preBuildDependencies,
						  const Array< Node * > & additionalInputs );
	virtual ~LibraryNode();

	static inline Node::Type GetType() { return Node::LIBRARY_NODE; }

	static Node * Load( IOStream & stream, bool remote );
	virtual bool Save( IOStream & stream, bool remote ) const;

	const char * GetObjExtension() const;

	void GetInputFiles( AString & fullArgs, const AString & pre, const AString & post ) const;
private:
	friend class FunctionLibrary;

	virtual bool DoDynamicDependencies( bool forceClean );
	virtual BuildResult DoBuild( Job * job );

	// internal helpers
	void GetFullArgs( AString & fullArgs ) const;
	bool CreateDynamicObjectNode( Node * inputFile );

	virtual Priority GetPriority() const { return PRIORITY_HIGH; }

	FileNode * m_Compiler;
	AString m_CompilerArgs;
	AString m_CompilerOutputPath;
	Array< Node * > m_CompilerForceUsing;
	AString m_LibrarianPath;
	AString m_LibrarianArgs;
	ObjectNode * m_PrecompiledHeader;
	AString m_ObjExtensionOverride;
	Array< Node * > m_AdditionalInputs;
};

//------------------------------------------------------------------------------
#endif // FBUILD_GRAPH_LIBRARYNODE_H
