// LinkerNode.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "ExeNode.h"

#include "Tools/FBuild/FBuildCore/FBuild.h"
#include "Tools/FBuild/FBuildCore/Graph/NodeGraph.h"

#include "Core/FileIO/IOStream.h"
#include "Core/Strings/AStackString.h"

// CONSTRUCTOR
//------------------------------------------------------------------------------
ExeNode::ExeNode( const AString & linkerOutputName,
				  const Array< Node * > & inputLibraries,
				  const Array< Node * > & otherLibraries,
				  const AString & linker,
				  const AString & linkerArgs,
				  uint32_t flags,
				  const Array< Node * > & assemblyResources )
: LinkerNode( linkerOutputName, inputLibraries, otherLibraries, linker, linkerArgs, flags, assemblyResources )
{
	m_Type = EXE_NODE;
}

// DESTRUCTOR
//------------------------------------------------------------------------------
ExeNode::~ExeNode()
{
}

// Load
//------------------------------------------------------------------------------
/*static*/ Node * ExeNode::Load( IOStream & stream, bool remote )
{
	NODE_LOAD( AStackString<>,	name );
	NODE_LOAD( AStackString<>,	linker );
	NODE_LOAD( AStackString<>,	linkerArgs );
	NODE_LOAD_DEPS( 0,			inputLibs);
	NODE_LOAD( uint32_t,		flags );
	NODE_LOAD_DEPS( 0,			assemblyResources );
	NODE_LOAD_DEPS( 0,			otherLibs );

	NodeGraph & ng = FBuild::Get().GetDependencyGraph();
	ExeNode * en = ng.CreateExeNode( name, inputLibs, otherLibs, linker, linkerArgs, flags, assemblyResources );
	return en;
}

//------------------------------------------------------------------------------
