// DirectoryListNode
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_GRAPH_DIRECTORYLISTNODE_H
#define FBUILD_GRAPH_DIRECTORYLISTNODE_H

// Includes
//------------------------------------------------------------------------------
#include "FileNode.h"

// Core
#include "Core/FileIO/FileIO.h"

// DirectoryListNode
//------------------------------------------------------------------------------
class DirectoryListNode : public Node
{
public:
	explicit DirectoryListNode( const AString & name,
								const AString & path,
								const AString & wildcard,
								bool recursive = false,
								const AString & excludePath = AString::GetEmpty() );
	virtual ~DirectoryListNode();

	const Array< FileIO::FileInfo > & GetFiles() const { return m_Files; }

	static inline Node::Type GetType() { return Node::DIRECTORY_LIST_NODE; }

	virtual bool IsAFile() const { return false; }

	static void FormatName( const AString & path,
							const AString & pattern,
							bool recursive,
							const AString & excludePath,
							AString & result );

	static Node * Load( IOStream & stream, bool remote );
	virtual bool Save( IOStream & stream, bool remote ) const;

private:
	virtual BuildResult DoBuild( Job * job );

	AString m_Path;
	AString m_WildCard;
	AString m_ExcludePath;
	bool m_Recursive;

	Array< FileIO::FileInfo > m_Files;
};

//------------------------------------------------------------------------------
#endif // FBUILD_GRAPH_DIRECTORYLISTNODE_H
