// DLLNode.h - builds a dll
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_GRAPH_DLLNODE_H
#define FBUILD_GRAPH_DLLNODE_H

// Includes
//------------------------------------------------------------------------------
#include "LinkerNode.h"

// Forward Declarations
//------------------------------------------------------------------------------

// DLLNode
//------------------------------------------------------------------------------
class DLLNode : public LinkerNode
{
public:
	explicit DLLNode( const AString & linkerOutputName,
					  const Array< Node * > & inputLibraries,
					  const Array< Node * > & otherLibraries,
					  const AString & linker,
					  const AString & linkerArgs,
					  uint32_t flags,
					  const Array< Node * > & assemblyResources,
					  const AString & importLibName );
	virtual ~DLLNode();

	void GetImportLibName( AString & importLibName ) const;

	static inline Node::Type GetType() { return Node::DLL_NODE; }

	static Node * Load( IOStream & stream, bool remote );
private:
	virtual bool Save( IOStream & stream, bool remote ) const;

	AString m_ImportLibName;
};

//------------------------------------------------------------------------------
#endif // FBUILD_GRAPH_LINKERNODE_H
