// LinkerNode.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "DLLNode.h"

#include "Tools/FBuild/FBuildCore/FBuild.h"
#include "Tools/FBuild/FBuildCore/Graph/NodeGraph.h"

#include "Core/FileIO/IOStream.h"
#include "Core/Strings/AStackString.h"

// CONSTRUCTOR
//------------------------------------------------------------------------------
DLLNode::DLLNode( const AString & linkerOutputName,
				  const Array< Node * > & inputLibraries,
				  const Array< Node * > & otherLibraries,
				  const AString & linker,
				  const AString & linkerArgs,
				  uint32_t flags,
				  const Array< Node * > & assemblyResources,
				  const AString & importLibName )
: LinkerNode( linkerOutputName, inputLibraries, otherLibraries, linker, linkerArgs, flags, assemblyResources )
, m_ImportLibName( importLibName )
{
	m_Type = DLL_NODE;
}

// DESTRUCTOR
//------------------------------------------------------------------------------
DLLNode::~DLLNode()
{
}

// GetImportLibName
//------------------------------------------------------------------------------
void DLLNode::GetImportLibName( AString & importLibName ) const
{
	// if the name was explicitly set by the user, use that
	if ( m_ImportLibName.IsEmpty() == false )
	{
		importLibName = m_ImportLibName;
		return;
	}

	// get name minus extension (handle no extension gracefully)
	const char * lastDot = GetName().FindLast( '.' );
	lastDot = lastDot ? lastDot : GetName().GetEnd();
	importLibName.Assign( GetName().Get(), lastDot );

	// assume .lib extension for import
	importLibName += ".lib";
}

// Load
//------------------------------------------------------------------------------
/*static*/ Node * DLLNode::Load( IOStream & stream, bool remote )
{
	NODE_LOAD( AStackString<>,	name );
	NODE_LOAD( AStackString<>,	linker );
	NODE_LOAD( AStackString<>,	linkerArgs );
	NODE_LOAD_DEPS( 0,			inputLibs);
	NODE_LOAD( uint32_t,		flags );
	NODE_LOAD_DEPS( 0,  		assemblyResources );
	NODE_LOAD_DEPS( 0,			otherLibs );
	NODE_LOAD( AStackString<>,	importLibName );

	NodeGraph & ng = FBuild::Get().GetDependencyGraph();
	DLLNode * dn = ng.CreateDLLNode( name, inputLibs, otherLibs, linker, linkerArgs, flags, assemblyResources, importLibName );
	return dn;
}

// Save
//------------------------------------------------------------------------------
/*virtual*/ bool DLLNode::Save( IOStream & stream, bool remote ) const
{
	// base class properties
	if ( LinkerNode::Save( stream, remote ) == false )
	{
		return false;
	}

	// out additional properties
	NODE_SAVE( m_ImportLibName );
	return true;
}

//------------------------------------------------------------------------------
