// CompilerNode.h - a node that manages a compiler executable 
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_GRAPH_COMPILERNODE_H
#define FBUILD_GRAPH_COMPILERNODE_H

// Includes
//------------------------------------------------------------------------------
#include "FileNode.h"
#include "Tools/FBuild/FBuildCore/Helpers/ToolManifest.h"

// Forward Declarations
//------------------------------------------------------------------------------

// CompilerNode
//------------------------------------------------------------------------------
class CompilerNode : public FileNode
{
public:
	explicit CompilerNode( const AString & exe,
						   const Array< Node * > & extraFiles );
	virtual ~CompilerNode();

	static inline Node::Type GetType() { return Node::COMPILER_NODE; }

	static Node * Load( IOStream & stream, bool remote );
	virtual bool Save( IOStream & stream, bool remote ) const;

	inline const ToolManifest & GetManifest() const { return m_Manifest; }

private:
	virtual BuildResult DoBuild( Job * job );

	ToolManifest	m_Manifest;
};

//------------------------------------------------------------------------------
#endif // FBUILD_GRAPH_COMPILERNODE_H
