// CompilerNode.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "CompilerNode.h"

#include "Tools/FBuild/FBuildCore/FBuild.h"
#include "Tools/FBuild/FBuildCore/Graph/NodeGraph.h"

#include "Core/FileIO/IOStream.h"
#include "Core/Strings/AStackString.h"

// CONSTRUCTOR
//------------------------------------------------------------------------------
CompilerNode::CompilerNode( const AString & exe,
						    const Array< Node * > & extraFiles )
	: FileNode( exe, ControlFlag::FLAG_NONE )
{
	m_StaticDependencies = extraFiles;
	m_Type = Node::COMPILER_NODE;
}

// DESTRUCTOR
//------------------------------------------------------------------------------
CompilerNode::~CompilerNode()
{
}

// DoBuild
//------------------------------------------------------------------------------
/*virtual*/ Node::BuildResult CompilerNode::DoBuild( Job * UNUSED( job ) )
{
	m_Manifest.Generate( m_StaticDependencies );
	return NODE_RESULT_OK;
}

// Load
//------------------------------------------------------------------------------
/*static*/ Node * CompilerNode::Load( IOStream & stream, bool remote )
{
	NODE_LOAD( AStackString<>, exeName );
	NODE_LOAD_DEPS( 16,		   staticDeps );

	NodeGraph & ng = FBuild::Get().GetDependencyGraph();
	Node * n = ng.CreateCompilerNode( exeName, staticDeps );
	ASSERT( n );
	return n;
}

// Save
//------------------------------------------------------------------------------
/*virtual*/ bool CompilerNode::Save( IOStream & stream, bool remote ) const
{
	NODE_SAVE( m_Name );
	NODE_SAVE_DEPS( m_StaticDependencies );
	return true;
}

//------------------------------------------------------------------------------
