// FunctionExecutable
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_FUNCTIONS_FUNCTIONEXECUTABLE_H
#define FBUILD_FUNCTIONS_FUNCTIONEXECUTABLE_H

// Includes
//------------------------------------------------------------------------------
#include "Function.h"

#include "Core/Containers/Array.h"

// Fwd Declarations
//------------------------------------------------------------------------------
class AString;
class Node;

// FunctionExecutable
//------------------------------------------------------------------------------
class FunctionExecutable : public Function
{
public:
	explicit		FunctionExecutable();
	inline virtual ~FunctionExecutable() {}

protected:
	virtual bool AcceptsHeader() const;
	virtual bool Commit( const BFFIterator & funcStartIter ) const;
private:
	// recursively process nodes to depend on
	bool DependOnNode( const BFFIterator & iter, const AString & nodeName, Array< Node * > & nodes ) const;
	bool DependOnNode( const BFFIterator & iter, Node * node, Array< Node * > & nodes ) const;

	void FunctionExecutable::GetImportLibName( const AString & args, AString & importLibName ) const;

	bool GetOtherLibraries( const BFFIterator & iter, const AString & args, Array< Node * > & otherLibraries, bool msvc ) const;
	static bool GetOtherLibsArg( const char * arg, 
								 Array< AString > & list, 
								 const AString * & it, 
								 const AString * const & end, 
								 bool canonicalizePath = false );
};

//------------------------------------------------------------------------------
#endif // FBUILD_FUNCTIONS_FUNCTIONEXECUTABLE_H
