// Timer.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "Timer.h"
#include "Core/Env/Assert.h"
#if defined( __WINDOWS__ )
    #include <Windows.h>
#endif

// Static
//------------------------------------------------------------------------------
int64_t Timer::s_Frequency = 0;
float Timer::s_FrequencyInvFloat = 0.0f;
float Timer::s_FrequencyInvFloatMS = 0.0f;

#if defined( __WINDOWS__ )
    // helper to initialize frequency at startup
    class GlobalTimerFrequencyInitializer
    {
    public:
        GlobalTimerFrequencyInitializer()
        {
            ASSERT( Timer::s_Frequency == 0 );
            LARGE_INTEGER freq;
            VERIFY( QueryPerformanceFrequency( &freq ) );
            Timer::s_Frequency = freq.QuadPart;
			Timer::s_FrequencyInvFloat = (float)( 1.0 / (double)Timer::s_Frequency );
			Timer::s_FrequencyInvFloatMS = (float)( 1.0 / (double)Timer::s_Frequency * 1000.0 );
        }
    };
    GlobalTimerFrequencyInitializer g_GlobalTimerFrequencyInitializer;
#endif

// GetNow
//------------------------------------------------------------------------------
int64_t Timer::GetNow()
{
    #if defined( __WINDOWS__ )
        ASSERT( s_Frequency );
        LARGE_INTEGER now;
        VERIFY( QueryPerformanceCounter( &now ) );
        return now.QuadPart;
    #elif defined( __APPLE__ )
        return 0; // TODO:MAC Implement
    #else
        #error Unknown platform
    #endif
}

//------------------------------------------------------------------------------
