// Thread
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "Thread.h"
#include "Core/Env/Assert.h"

#if defined( __WINDOWS__ )
    #include <windows.h>
#endif

// Debug Structure for thread name setting
//------------------------------------------------------------------------------
#if defined( __WINDOWS__ )
    #ifdef DEBUG
        #pragma pack(push,8)
        typedef struct tagTHREADNAME_INFO
        {
           DWORD dwType; // Must be 0x1000.
           LPCSTR szName; // Pointer to name (in user addr space).
           DWORD dwThreadID; // Thread ID (-1=caller thread).
           DWORD dwFlags; // Reserved for future use, must be zero.
        } THREADNAME_INFO;
        #pragma pack(pop)
    #endif
#endif

// Static Data
//------------------------------------------------------------------------------
/*static*/ Thread::ThreadId Thread::s_MainThreadId( Thread::GetCurrentThreadId() );

// GetCurrentThreadId
//------------------------------------------------------------------------------
/*static*/ Thread::ThreadId Thread::GetCurrentThreadId()
{
	#if defined( __WINDOWS__ )
		return (Thread::ThreadId) ::GetCurrentThreadId();
    #elif defined( __APPLE__ )
        return 0; // TODO:MAC Implement 
    #else
        #error Unknown platform GetCurrentThreadId
	#endif
}

//  Sleep
//------------------------------------------------------------------------------
/*static*/ void Thread::Sleep( int32_t ms )
{
    #if defined( WIN32 ) || defined( WIN64 )
        ::Sleep( ms );
    #elif defined( __APPLE__ )
        // TODO:MAC Implemnt Sleep
    #else
        #error Unknown platform
    #endif
}

// CreateThread
//------------------------------------------------------------------------------
/*static*/ Thread::ThreadHandle Thread::CreateThread( ThreadEntryFunction entryFunc,
													  const char * threadName,
													  uint32_t stackSize,
													  void * userData )
{
	#if defined( __WINDOWS__ )
		DWORD threadId;
		HANDLE h = ::CreateThread( nullptr,		// LPSECURITY_ATTRIBUTES lpThreadAttributes
								 stackSize,		// SIZE_T dwStackSize
								 (LPTHREAD_START_ROUTINE)entryFunc,	// LPTHREAD_START_ROUTINE lpStartAddress
								 userData,		// LPVOID lpParameter
								 0,				// DWORD dwCreationFlags
								 (LPDWORD)&threadId		// LPDWORD lpThreadId
							   );
		ASSERT( h != nullptr );

		// set thread name to assist debugging
		#ifdef DEBUG
			if ( threadName )
			{
				const DWORD MS_VC_EXCEPTION=0x406D1388;

				THREADNAME_INFO info;
				info.dwType = 0x1000;
				info.szName = threadName;
				info.dwThreadID = threadId;
				info.dwFlags = 0;

				__try
				{
					RaiseException( MS_VC_EXCEPTION, 0, sizeof(info)/sizeof(ULONG_PTR), (ULONG_PTR*)&info );
				}
				PRAGMA_DISABLE_PUSH_MSVC( 6320 ) // Exception-filter expression is the constant EXCEPTION_EXECUTE_HANDLER
				__except( EXCEPTION_EXECUTE_HANDLER )
				PRAGMA_DISABLE_POP_MSVC
				{
					(void)0;
				}
			}
		#else
			(void)threadName;
			(void)threadId;
		#endif
	
		return h;
    #elif defined( __APPLE__ )
        return 0; // TODO:MAC Implement Thread
    #else
        #error Unknown platform
	#endif
}

// CloseHandle
//------------------------------------------------------------------------------
/*static*/ void Thread::CloseHandle( ThreadHandle h )
{
	#if defined( __WINDOWS__ )
		::CloseHandle( h );
    #elif defined( __APPLE__ )
        // TODO:MAC Implement Thread
    #else
        #error Unknown platform
	#endif
}

//------------------------------------------------------------------------------
