// Mutex
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "Mutex.h"

#if defined( __WINDOWS__ )
    #include <windows.h>
    #include "Core/Env/Assert.h"
#endif

// CONSTRUCTOR
//------------------------------------------------------------------------------
Mutex::Mutex()
{ 
    #if defined( __WINDOWS__ )
        CTASSERT( sizeof( m_CriticalSection ) == sizeof( CRITICAL_SECTION ) );

        VERIFY( InitializeCriticalSectionAndSpinCount( (CRITICAL_SECTION *)&m_CriticalSection, 100 ) );
    #elif defined( __APPLE__ )
        // TODO:MAC Implement Mutex
    #else
        #error Unknown platform
    #endif
}

// DESTRUCTOR
//------------------------------------------------------------------------------
Mutex::~Mutex()
{ 
    #if defined( __WINDOWS__ )
        DeleteCriticalSection( (CRITICAL_SECTION *)&m_CriticalSection );
    #elif defined( __APPLE__ )
        // TODO:MAC Implement Mutex
    #else
        #error Unknown platform
    #endif
}

PRAGMA_DISABLE_PUSH_MSVC( 26135 ) // static analysis complains about missing annotation
// Lock
//------------------------------------------------------------------------------
void Mutex::Lock()
{ 
    #if defined( __WINDOWS__ )
        EnterCriticalSection( (CRITICAL_SECTION *)&m_CriticalSection );
    #elif defined( __APPLE__ )
        // TODO:MAC Implement Mutex
    #else
        #error Unknown platform
    #endif
}
// Unlock
//------------------------------------------------------------------------------
void Mutex::Unlock()
{
    #if defined( __WINDOWS__ )
        LeaveCriticalSection( (CRITICAL_SECTION *)&m_CriticalSection );
    #elif defined( __APPLE__ )
        // TODO:MAC Implement Mutex
    #else
        #error Unknown platform
    #endif
}
PRAGMA_DISABLE_POP_MSVC

//------------------------------------------------------------------------------
