// Atomic.h
//------------------------------------------------------------------------------
#pragma once
#ifndef CORE_PROCESS_ATOMIC_H
#define CORE_PROCESS_ATOMIC_H

// Includes
//------------------------------------------------------------------------------
#include "Core/Env/Types.h"
#include <windows.h>

// 32bit
//------------------------------------------------------------------------------
int32_t AtomicInc32( volatile int32_t * i )
{
	return InterlockedIncrement( (volatile uint32_t *)i );
}
uint32_t AtomicIncU32( volatile uint32_t * i )
{
	return InterlockedIncrement( i );
}
int32_t AtomicDec32( volatile int32_t * i )
{
	return InterlockedDecrement( (volatile uint32_t *)i );
}
uint32_t AtomicDecU32( volatile uint32_t * i )
{
	return InterlockedDecrement( i );
}

// 64bit
//------------------------------------------------------------------------------
int64_t AtomicInc64( volatile int64_t * i )
{
	return InterlockedIncrement64( i );
}
uint64_t AtomicIncU64( volatile uint64_t * i )
{
	return InterlockedIncrement64( (volatile int64_t *)i );
}
int64_t AtomicDec64( volatile int64_t * i )
{
	return InterlockedDecrement64( i );
}
uint64_t AtomicDecU64( volatile uint64_t * i )
{
	return InterlockedDecrement64( (volatile int64_t *)i );
}

// Ptr
//------------------------------------------------------------------------------
void * AtomicIncPtr( volatile void * * ptr )
{
#ifdef WIN32
	return (void *)InterlockedIncrement( (volatile uint32_t *)ptr );
#elif defined( WIN64 )
	return (void *)InterlockedIncrement64( (volatile int64_t *)ptr );
#else
	#error Unknown platform
#endif
}

//------------------------------------------------------------------------------
#endif // CORE_PROCESS_ATOMIC_H
