// Mem.h
//------------------------------------------------------------------------------
#pragma once
#ifndef CORE_MEM_MEM_H
#define CORE_MEM_MEM_H

// Placement new/delete
//------------------------------------------------------------------------------
#define INPLACE_NEW new
inline void * operator new( size_t, void * ptr ) { return ptr; }
inline void * operator new[]( size_t, void * ptr ) { return ptr; }
inline void operator delete( void *, void * ) {}
inline void operator delete[]( void *, void * ) {}

// Alloc/Free
//------------------------------------------------------------------------------
void * Alloc( size_t size );
void * Alloc( size_t size, size_t alignment );
void Free( void * ptr );

// global new/delete
//------------------------------------------------------------------------------
inline void * operator new( size_t size ) { return Alloc( size ); }
inline void * operator new[]( size_t size ) { return Alloc( size ); }
inline void operator delete( void * ptr ) { Free( ptr ); }
inline void operator delete[]( void * ptr ) { Free( ptr ); }

//------------------------------------------------------------------------------
#endif // CORE_MEM_MEM_H
