// Conversion.h
//------------------------------------------------------------------------------
#pragma once
#ifndef CORE_MATH_CONVERSIONS_H
#define CORE_MATH_CONVERSIONS_H

// Includes
//------------------------------------------------------------------------------
#include "Core/Env/Types.h"

// Math
//------------------------------------------------------------------------------
class Math
{
public:
	static inline uint16_t RoundUp( uint16_t value, uint16_t alignment )
	{
		return ( value + alignment - 1) & ~( alignment - 1 );
	}
	static inline uint32_t RoundUp( uint32_t value, uint32_t alignment )
	{
		return ( value + alignment - 1) & ~( alignment - 1 );
	}
	static inline uint64_t RoundUp( uint64_t value, uint64_t alignment )
	{
		return ( value + alignment - 1) & ~( alignment - 1 );
	}
	template <class T>
	static inline T Max( T a, T b )
	{
		return ( a > b ) ? a : b;
	}
	template <class T>
	static inline T Min( T a, T b )
	{
		return ( a < b ) ? a : b;
	}
};

//------------------------------------------------------------------------------
#endif // CORE_MATH_CONVERSIONS_H
