// MemoryStream.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "MemoryStream.h"

#include <memory.h> // for memcpy

// Defines
//------------------------------------------------------------------------------

// CONSTRUCTOR
//------------------------------------------------------------------------------
MemoryStream::MemoryStream()
	: m_Buffer( 0, true )
	, m_CurrentPos( 0 )
	, m_MinGrowth( 4096 )
{
}

// CONSTRUCTOR
//------------------------------------------------------------------------------
MemoryStream::MemoryStream( size_t initialBufferSize, size_t minGrowthFactor )
	: m_Buffer( initialBufferSize, true )
	, m_CurrentPos( 0 )
	, m_MinGrowth( minGrowthFactor )
{
}

// DESTRUCTOR
//------------------------------------------------------------------------------
MemoryStream::~MemoryStream()
{
}

// Read
//------------------------------------------------------------------------------
uint64_t MemoryStream::ReadBuffer( void * buffer, uint64_t bytesToRead )
{
	(void)buffer; (void)bytesToRead;
	ASSERT( false ); // Not implemented - implement if required
	return 0;
}

// Write
//------------------------------------------------------------------------------
uint64_t MemoryStream::WriteBuffer( const void * buffer, uint64_t bytesToWrite )
{
	// grow the buffer if necessary
	size_t requiredCapacity = ( m_CurrentPos + (size_t)bytesToWrite );
	if ( requiredCapacity > m_Buffer.GetCapacity() )
	{
		size_t newCapacity = m_CurrentPos + Math::Max<size_t>( (size_t)bytesToWrite, m_MinGrowth ); // grow by at least MinGrowth
		m_Buffer.SetCapacity( newCapacity );
	}

	// expand for new size if required
	size_t minimumNewSize = m_CurrentPos + (size_t)bytesToWrite;
	if ( minimumNewSize > m_Buffer.GetSize() )
	{
		m_Buffer.SetSize( minimumNewSize );
	}

	// copy new data
	memcpy( m_Buffer.Begin() + m_CurrentPos, buffer, (size_t)bytesToWrite );
	m_CurrentPos += (size_t)bytesToWrite;

	return bytesToWrite;
}

// Flush
//------------------------------------------------------------------------------
void MemoryStream::Flush()
{
	// nothing to do
}

// Tell
//------------------------------------------------------------------------------
uint64_t MemoryStream::Tell() const
{
	ASSERT( false ); // Not implemented - implement if required
	return 0;
}

// Seek
//------------------------------------------------------------------------------
bool MemoryStream::Seek( uint64_t pos ) const
{
	(void)pos;
	ASSERT( false ); // Not implemented - implement if required
	return true;
}

// GetFileSize
//------------------------------------------------------------------------------
uint64_t MemoryStream::GetFileSize() const
{
	return GetSize();
}

//------------------------------------------------------------------------------
