// IOStream - interface for serialization
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "IOStream.h"
#include "Core/Strings/AString.h"

// Read (AString)
//------------------------------------------------------------------------------
bool IOStream::Read( AString & string )
{
	uint32_t len;
	if ( Read( len ) )
	{
		string.SetLength( len );
		return ( Read( string.Get(), len ) == len );
	}
	return false;
}

// Write (AString)
//------------------------------------------------------------------------------
bool IOStream::Write( const AString & string )
{
	uint32_t len = string.GetLength();
	if ( Write( len ) &&
		 Write( string.Get(), len ) == len )
	{
		return true;
	}
	return false;
}

//------------------------------------------------------------------------------
