// Assert.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "Assert.h"
#ifdef ASSERTS_ENABLED
	#include "Core/Env/Types.h"
	#include "Core/Strings/AString.h"
	#include <stdio.h>
    #if defined( __WINDOWS__ )
        #include <windows.h>
    #endif
#endif

// Static
//------------------------------------------------------------------------------
#ifdef ASSERTS_ENABLED
/*static*/ bool AssertHandler::s_ThrowOnAssert( false );
#endif

// Failure
//------------------------------------------------------------------------------
#ifdef ASSERTS_ENABLED
/*static*/ bool AssertHandler::Failure( const char * message, 
										const char * file,  
										const int line )
{
	#ifdef DEBUG
		const uint32_t BUFFER_SIZE( 4096 );
		char buffer[ BUFFER_SIZE ];
        #ifdef __APPLE__
            sprintf( buffer,
        #else
            sprintf_s( buffer, BUFFER_SIZE,
        #endif
			"\n-------- ASSERTION FAILED --------\n%s(%i): Assert: %s\n-----^^^ ASSERTION FAILED ^^^-----\n",
			file, line, message );

		puts( buffer );
        #if defined( __WINDOWS__ )
            OutputDebugStringA( buffer );
        #endif
    
		#if defined( __WINDOWS__ )
			if ( s_ThrowOnAssert )
			{
				throw "AssertionFailed";
			}
			if ( IsDebuggerPresent() == false )
			{
				int res = MessageBox( nullptr, buffer, "Assertion Failed - Break Execution?", MB_YESNO | MB_ICONERROR );
				return ( res == IDYES );
			}
			return true;
		#else
			return true; // break execution
		#endif
	#else
		return true; // break execution
	#endif
}

//------------------------------------------------------------------------------
#endif // ASSERTS_ENABLED
