// WorkerWindow
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_FBUILDWORKER_WORKERWINDOW_H
#define FBUILD_FBUILDWORKER_WORKERWINDOW_H

// Includes
//------------------------------------------------------------------------------
#include <Core/Containers/Singleton.h>
#include <Core/Process/Thread.h>

#include <windows.h>
#include <shellapi.h>

// Forward Declaration
//------------------------------------------------------------------------------
class AString;

// WorkerWindow
//------------------------------------------------------------------------------
class WorkerWindow : public Singleton< WorkerWindow >
{
public:
	explicit WorkerWindow( void * hInstance );
	~WorkerWindow();

	void SetStatus( const char * statusText );
	void SetWorkerState( size_t index, const AString & status );

	HWND GetWindowHandle() const { return m_WindowHandle; }
	HMENU GetMenu() const { return m_Menu; }

	bool WantToQuit() const { return ( m_UIState == WANT_TO_QUIT ); }
	void SetWantToQuit() { m_UIState = WANT_TO_QUIT; }
	void SetAllowQuit() { m_UIState = ALLOWED_TO_QUIT; }

private:
	static uint32_t UIUpdateThreadWrapper( void * );
	void UIUpdateThread();

	// UI created/updated in another thread to ensure responsiveness at all times
	enum UIThreadState
	{
		NOT_READY,		// UI is not yet created
		UPDATING,		// UI is created and is being updated
		WANT_TO_QUIT,	// UI wants to close down
		ALLOWED_TO_QUIT	// main thread has authorized UI shut down
	};
	volatile UIThreadState	m_UIState;
	//volatile bool			m_UIThreadQuitNotification;	// does UI want to exit (app closed etc)
	//volatile bool			m_UIThreadExitAllowed;		// main thread acknowledged exit and it's safe to shutdown thread
	Thread::ThreadHandle	m_UIThreadHandle;

	// properties of the window
	HWND			m_WindowHandle;		// the main window
	HMENU			m_Menu;				// right-click context menu
	NOTIFYICONDATA	m_NotifyIconData;	// tray icon
	HINSTANCE		m_HInstance;		// main application instance to tie window to

	// sub items of the window
	HWND			m_ThreadListView;	// list showing worker thread status
};

//------------------------------------------------------------------------------
#endif // FBUILD_FBUILDWORKER_WORKERWINDOW_H
