// Worker
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include <winsock2.h> // this must be here to avoid windows include order problems

#include "Worker.h"
#include "WorkerWindow.h"

#include <Tools/FBuild/FBuildCore/Protocol/Protocol.h>
#include <Tools/FBuild/FBuildCore/Protocol/Server.h>
#include <Tools/FBuild/FBuildCore/WorkerPool/JobQueueRemote.h>

#include <Core/Env/Env.h>
#include <Core/Strings/AStackString.h>

// CONSTRUCTOR
//------------------------------------------------------------------------------
Worker::Worker( void * hInstance )
	: m_MainWindow( nullptr )
	, m_ConnectionPool( nullptr )
{
	m_JobQueueRemote = new JobQueueRemote( Env::GetNumProcessors() );
	m_MainWindow = new WorkerWindow( hInstance );
	m_ConnectionPool = new Server; 
}

// DESTRUCTOR
//------------------------------------------------------------------------------
Worker::~Worker()
{
	delete m_ConnectionPool;
	delete m_MainWindow;
	delete m_JobQueueRemote;
}

// Work
//------------------------------------------------------------------------------
int Worker::Work()
{
	// start listening
	if ( m_ConnectionPool->Listen( Protocol::PROTOCOL_PORT ) == false )
	{
		AStackString<> msg;
		msg.Format( "Failed to listen on port %u.  Check port is not in use.", Protocol::PROTOCOL_PORT );
		MessageBox( nullptr, msg.Get(), "FBuild Worker", MB_OK );
		return -1;
	}

	while ( WorkerWindow::Get().WantToQuit() == false )
	{
		UpdateUI();

		Sleep( 100 );
	}

	// allow to UI to shutdown
	// the application MUST NOT try to update the UI from this point on
	m_MainWindow->SetAllowQuit();

	return 0;
}

// UpdateUI
//------------------------------------------------------------------------------
void Worker::UpdateUI()
{
	// title bar
	size_t numConnections = m_ConnectionPool->GetNumConnections();
	AStackString<> status;
	status.Format( "Connections %u", (uint32_t)numConnections );
	m_MainWindow->SetStatus( status.Get() );

	// thread output
	JobQueueRemote & jqr = JobQueueRemote::Get();
	const size_t numWorkers = jqr.GetNumWorkers();
	for ( size_t i=0; i<numWorkers; ++i )
	{
		// get status of worker
		AStackString<> status;
		jqr.GetWorkerStatus( i, status );

		// reflect in UI
		m_MainWindow->SetWorkerState( i, status );
	}
}

//------------------------------------------------------------------------------
