// Main
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "Worker/Worker.h"

#include <windows.h>

// main
//------------------------------------------------------------------------------
#pragma warning ( push )
#pragma warning (disable:28251) // don't complain about missing annotations on WinMain
int WINAPI WinMain( HINSTANCE hInstance, 
					HINSTANCE /*hPrevInstance*/,
					LPSTR /*lpCmdLine*/, 
					int /*nCmdShow*/ )
{
	// only allow 1 worker per system
	CreateMutex( nullptr, TRUE, "Global\\FBuildWorker" );
	if ( GetLastError() == ERROR_ALREADY_EXISTS )
	{
		MessageBoxA( nullptr, "An FBuildWorker is already running!", "FBuildWorker", MB_OK );
		return -1;
	}

	// start the worker and wait for it to be closed
	Worker worker( hInstance );
	return worker.Work();
}
#pragma warning ( pop )

//------------------------------------------------------------------------------
