// TestUnity.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include <TestFramework/UnitTest.h>

#include <Tools/FBuild/FBuildCore/FBuild.h>
#include <Tools/FBuild/FBuildCore/BFF/BFFParser.h>

#include <Core/Containers/AutoPtr.h>
#include <Core/FileIO/FileIO.h>
#include <Core/FileIO/FileStream.h>
#include <Core/Strings/AStackString.h>

// TestUnity
//------------------------------------------------------------------------------
class TestUnity : public UnitTest
{
private:
	DECLARE_TESTS

	void Test() const;
};

// Register Tests
//------------------------------------------------------------------------------
REGISTER_TESTS_BEGIN( TestUnity )
	REGISTER_TEST( Test )
REGISTER_TESTS_END

// Parse
//------------------------------------------------------------------------------
void TestUnity::Test() const
{
	FBuildOptions options;
	options.m_ConfigFile = "Data/TestUnity/unity.bff";

	FBuild fBuild( options );
	TEST_ASSERT( fBuild.Initialize() );

	// delete files from previous runs
	Array< AString > files( 1024, true );
	FileIO::GetFiles( AStackString<>( "../../../../ftmp/Test/Unity/" ), AStackString<>( "*" ), true, &files );
	for ( Array< AString >::Iter it = files.Begin();
		  it != files.End();
		  it++ )
	{
		FileIO::FileDelete( (*it).Get() );
	}

	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/Unity/Unity1.cpp" ) == false );
	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/Unity/Unity2.cpp" ) == false );
	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/Unity/Unity.lib" ) == false );

	// Implement Unity and activate this test
	TEST_ASSERT( fBuild.Build( AStackString<>( "Unity-Test" ) ) );
	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/Unity/Unity1.cpp" ) );
	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/Unity/Unity2.cpp" ) );

	// Test compilation of generated Unity files
	TEST_ASSERT( fBuild.Build( AStackString<>( "Unity-Compiled" ) ) );
	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/Unity/Unity1.obj" ) );
	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/Unity/Unity2.obj" ) );
	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/Unity/Unity.lib" ) );
}

//------------------------------------------------------------------------------
