// TestPrecompiledHeaders.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include <TestFramework/UnitTest.h>

#include <Tools/FBuild/FBuildCore/FBuild.h>

#include <Core/FileIO/FileIO.h>
#include <Core/Strings/AStackString.h>

// TestPrecompiledHeaders
//------------------------------------------------------------------------------
class TestPrecompiledHeaders : public UnitTest
{
private:
	DECLARE_TESTS

	void TestPCH( FBuildOptions options = FBuildOptions() ) const;
	void TestPCHWithCache() const;
};

// Register Tests
//------------------------------------------------------------------------------
REGISTER_TESTS_BEGIN( TestPrecompiledHeaders )
	REGISTER_TEST( TestPCH )
	REGISTER_TEST( TestPCHWithCache )
REGISTER_TESTS_END

// TestPCH
//------------------------------------------------------------------------------
void TestPrecompiledHeaders::TestPCH( FBuildOptions options ) const
{
	options.m_ConfigFile = "Data/TestPrecompiledHeaders/fbuild.bff";
	options.m_ForceCleanBuild = true;
	//options.m_ShowInfo = true;

	FBuild fBuild( options );

	AStackString<> target( "PCHTest" );
	AStackString<> obj( "../../../../ftmp/Test/PrecompiledHeaders/PCHUser.obj" );
	AStackString<> pch( "../../../../ftmp/Test/PrecompiledHeaders/PrecompiledHeader.pch" );
	AStackString<> lib( "../../../../ftmp/Test/PrecompiledHeaders/TestPCH.lib" );
	FileIO::FileDelete( obj.Get() );
	FileIO::FileDelete( pch.Get() );
	FileIO::FileDelete( lib.Get() );
	TEST_ASSERT( FileIO::FileExists( obj.Get() ) == false );
	TEST_ASSERT( FileIO::FileExists( pch.Get() ) == false );
	TEST_ASSERT( FileIO::FileExists( lib.Get() ) == false );

	TEST_ASSERT( fBuild.Initialize() );
	TEST_ASSERT( fBuild.Build( target ) );

	TEST_ASSERT( FileIO::FileExists( obj.Get() ) );
	TEST_ASSERT( FileIO::FileExists( pch.Get() ) );
	TEST_ASSERT( FileIO::FileExists( lib.Get() ) );
}

// TestPCHWithCache
//------------------------------------------------------------------------------
void TestPrecompiledHeaders::TestPCHWithCache() const
{
	FBuildOptions options;
	options.m_UseCacheRead = true;
	options.m_UseCacheWrite = true;
	TestPCH( options );
}

//------------------------------------------------------------------------------
