// TestDistributed.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include <TestFramework/UnitTest.h>

#include <Tools/FBuild/FBuildCore/FBuild.h>
#include <Tools/FBuild/FBuildCore/Protocol/Protocol.h>
#include <Tools/FBuild/FBuildCore/Protocol/Server.h>
#include <Tools/FBuild/FBuildCore/WorkerPool/JobQueueRemote.h>

#include <Core/FileIO/FileIO.h>
#include <Core/Strings/AStackString.h>

// TestDistributed
//------------------------------------------------------------------------------
class TestDistributed : public UnitTest
{
private:
	DECLARE_TESTS
	//DECLARE_TESTS_RUN_ONLY_THIS_TEST

	void TestWith1RemoteWorkerThread() const;
	void TestWith4RemoteWorkerThreads()	const;
	void WithPCH() const;

	void TestHelper( const char * target,
					 uint32_t numRemoteWorkers ) const;
};

// Register Tests
//------------------------------------------------------------------------------
REGISTER_TESTS_BEGIN( TestDistributed )
	REGISTER_TEST( TestWith1RemoteWorkerThread )
	REGISTER_TEST( TestWith4RemoteWorkerThreads )
	REGISTER_TEST( WithPCH )
REGISTER_TESTS_END

// Test
//------------------------------------------------------------------------------
void TestDistributed::TestHelper( const char * target, uint32_t numRemoteWorkers ) const
{
	JobQueueRemote jqr( numRemoteWorkers );

	// start a client to emulate the other end
	Server s;
	s.Listen( Protocol::PROTOCOL_PORT );

	FBuildOptions options;
	options.m_ConfigFile = "Data/TestDistributed/fbuild.bff";
	options.m_AllowDistributed = true;
	options.m_NumWorkerThreads = 1;
	//options.m_ShowProgress = true;
	//options.m_ShowInfo = true;
	//options.m_ShowSummary = true;
	FBuild fBuild( options );
	TEST_ASSERT( fBuild.Initialize() );

	// clean up anything left over from previous runs
	Array< AString > files;
	FileIO::GetFiles( AStackString<>( "..\\..\\..\\..\\ftmp\\Test\\Distributed" ), AStackString<>( "*.*" ), true, &files );
	auto iter = files.Begin();
	auto end = files.End();
	for ( ; iter != end; ++iter )
	{
		FileIO::FileDelete( iter->Get() );
	}

	TEST_ASSERT( FileIO::FileExists( target ) == false );

	TEST_ASSERT( fBuild.Build( AStackString<>( target ) ) );

	// make sure all output files are as expected
	TEST_ASSERT( FileIO::FileExists( target ) );
}

// TestWith1RemoteWorkerThread
//------------------------------------------------------------------------------
void TestDistributed::TestWith1RemoteWorkerThread() const
{
	const char * target( "..\\..\\..\\..\\ftmp\\Test\\Distributed\\dist.lib" );
	TestHelper( target, 1 );
}

// TestWith4RemoteWorkerThreads
//------------------------------------------------------------------------------
void TestDistributed::TestWith4RemoteWorkerThreads() const
{
	const char * target( "..\\..\\..\\..\\ftmp\\Test\\Distributed\\dist.lib" );
	TestHelper( target, 4 );
}

// WithPCH
//------------------------------------------------------------------------------
void TestDistributed::WithPCH() const
{
	const char * target( "..\\..\\..\\..\\ftmp\\Test\\Distributed\\distpch.lib" );
	TestHelper( target, 4 );
}

//------------------------------------------------------------------------------
