// TestBuildAndLinkLibrary.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include <TestFramework/UnitTest.h>

#include <Tools/FBuild/FBuildCore/FBuild.h>

#include <Core/FileIO/FileIO.h>
#include <Core/Strings/AStackString.h>

// TestBuildAndLinkLibrary
//------------------------------------------------------------------------------
class TestDLL : public UnitTest
{
private:
	DECLARE_TESTS

	void TestSingleDLL() const;
};

// Register Tests
//------------------------------------------------------------------------------
REGISTER_TESTS_BEGIN( TestDLL )
	REGISTER_TEST( TestSingleDLL )
REGISTER_TESTS_END

// TestSingleDLL
//------------------------------------------------------------------------------
void TestDLL::TestSingleDLL() const
{
	FBuildOptions options;
	options.m_ConfigFile = "Data/TestDLL/fbuild.bff";
	FBuild fBuild( options );
	TEST_ASSERT( fBuild.Initialize() );

	const AStackString<> dll( "..\\..\\..\\..\\ftmp\\Test\\DLL\\dll.dll" );

	// clean up anything left over from previous runs
	FileIO::FileDelete( dll.Get() );
	TEST_ASSERT( FileIO::FileExists( dll.Get() ) == false );

	TEST_ASSERT( fBuild.Build( dll ) );

	// make sure all output files are as expecter
	TEST_ASSERT( FileIO::FileExists( dll.Get() ) );
}

//------------------------------------------------------------------------------
