// TestCSharp.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include <TestFramework/UnitTest.h>

#include <Tools/FBuild/FBuildCore/FBuild.h>
#include <Tools/FBuild/FBuildCore/BFF/BFFParser.h>

#include <Core/FileIO/FileIO.h>
#include <Core/Strings/AStackString.h>

// TestCSharp
//------------------------------------------------------------------------------
class TestCSharp : public UnitTest
{
private:
	DECLARE_TESTS

	void TestSingleFile() const;
	void TestMultipleFiles() const;
	void TestMultipleAssemblies() const;
	void TestMixedAssemblyWithCPP() const;
};

// Register Tests
//------------------------------------------------------------------------------
REGISTER_TESTS_BEGIN( TestCSharp )
	REGISTER_TEST( TestSingleFile )
	REGISTER_TEST( TestMultipleFiles )
	REGISTER_TEST( TestMultipleAssemblies )
//	REGISTER_TEST( TestMixedAssemblyWithCPP ) // TODO:A Enable
REGISTER_TESTS_END

// TestSingleFile
//------------------------------------------------------------------------------
void TestCSharp::TestSingleFile() const
{
	FBuildOptions options;
	options.m_ConfigFile = "Data/TestCSharp/csharp.bff";

	FBuild fBuild( options );
	TEST_ASSERT( fBuild.Initialize() );

	// delete files from previous runs
	FileIO::FileDelete( "../../../../ftmp/Test/CSharp/csharpsingle.dll" );

	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/CSharp/csharpsingle.dll" ) == false );
	
	// Build it
	TEST_ASSERT( fBuild.Build( AStackString<>( "CSharp-Single-Target" ) ) );

	// Test output files
	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/CSharp/csharpsingle.dll" ) );

	// Build it again
	TEST_ASSERT( fBuild.Build( AStackString<>( "CSharp-Single-Target" ) ) );
	// TODO:B Assert no build performed
}

// TestMultipleFiles
//------------------------------------------------------------------------------
void TestCSharp::TestMultipleFiles() const
{
	FBuildOptions options;
	options.m_ConfigFile = "Data/TestCSharp/csharp.bff";

	FBuild fBuild( options );
	TEST_ASSERT( fBuild.Initialize() );

	// delete files from previous runs
	FileIO::FileDelete( "../../../../ftmp/Test/CSharp/csharpmulti.dll" );

	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/CSharp/csharpmulti.dll" ) == false );
	
	// Build it
	TEST_ASSERT( fBuild.Build( AStackString<>( "CSharp-Multi-Target" ) ) );

	// Test output files
	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/CSharp/csharpmulti.dll" ) );

	// Build it again
	TEST_ASSERT( fBuild.Build( AStackString<>( "CSharp-Multi-Target" ) ) );
	// TODO:B Assert no build performed
}

// TestMultipleAssemblies
//------------------------------------------------------------------------------
void TestCSharp::TestMultipleAssemblies() const
{
	FBuildOptions options;
	options.m_ConfigFile = "Data/TestCSharp/csharp.bff";
	//options.m_ShowInfo = true;

	FBuild fBuild( options );
	TEST_ASSERT( fBuild.Initialize() );

	// delete files from previous runs
	FileIO::FileDelete( "../../../../ftmp/Test/CSharp/csharpassemblya.dll" );
	FileIO::FileDelete( "../../../../ftmp/Test/CSharp/csharpassemblyb.dll" );

	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/CSharp/csharpassemblya.dll" ) == false );
	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/CSharp/csharpassemblyb.dll" ) == false );
	
	// Build it
	TEST_ASSERT( fBuild.Build( AStackString<>( "CSharp-AssemblyB" ) ) );

	// Test output files
	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/CSharp/csharpassemblya.dll" ) );
	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/CSharp/csharpassemblyb.dll" ) );

	// Build it again
	TEST_ASSERT( fBuild.Build( AStackString<>( "CSharp-AssemblyB" ) ) );
	// TODO:B Assert no build performed
}

// TestMixedAssemblyWithCPP
//------------------------------------------------------------------------------
void TestCSharp::TestMixedAssemblyWithCPP() const
{
	// TODO:A Implement functionality and tests
}

//------------------------------------------------------------------------------
