// TestCLR.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include <TestFramework/UnitTest.h>

#include <Tools/FBuild/FBuildCore/FBuild.h>
#include <Tools/FBuild/FBuildCore/BFF/BFFParser.h>

#include <Core/FileIO/FileIO.h>
#include <Core/Strings/AStackString.h>

// TestBFFParsing
//------------------------------------------------------------------------------
class TestCLR : public UnitTest
{
private:
	DECLARE_TESTS

	void Test() const;
};

// Register Tests
//------------------------------------------------------------------------------
REGISTER_TESTS_BEGIN( TestCLR )
	REGISTER_TEST( Test )
REGISTER_TESTS_END

// Test
//------------------------------------------------------------------------------
void TestCLR::Test() const
{
	FBuildOptions options;
	options.m_ConfigFile = "Data/TestCLR/clr.bff";

	FBuild fBuild( options );
	TEST_ASSERT( fBuild.Initialize() );

	// delete files from previous runs
	Array< AString > files( 1024, true );
	FileIO::GetFiles( AStackString<>( "../../../../ftmp/Test/CLR/" ), AStackString<>( "*" ), true, &files );
	for ( Array< AString >::Iter it = files.Begin();
		  it != files.End();
		  it++ )
	{
		FileIO::FileDelete( (*it).Get() );
	}

	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/CLR/clr.lib" ) == false );
	
	// Build it
	TEST_ASSERT( fBuild.Build( AStackString<>( "CLR-Target" ) ) );

	// Test output files
	TEST_ASSERT( FileIO::FileExists( "../../../../ftmp/Test/CLR/clr.lib" ) );
}

//------------------------------------------------------------------------------
