// TestBuildAndLinkLibrary.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include <TestFramework/UnitTest.h>

#include <Tools/FBuild/FBuildCore/FBuild.h>

#include <Core/FileIO/FileIO.h>
#include <Core/Strings/AStackString.h>

// TestBuildAndLinkLibrary
//------------------------------------------------------------------------------
class TestBuildAndLinkLibrary : public UnitTest
{
private:
	DECLARE_TESTS

	void TestParseBFF() const;
	void TestBuildLib() const;
};

// Register Tests
//------------------------------------------------------------------------------
REGISTER_TESTS_BEGIN( TestBuildAndLinkLibrary )
	REGISTER_TEST( TestParseBFF )
	REGISTER_TEST( TestBuildLib )
REGISTER_TESTS_END

// TestStackFramesEmpty
//------------------------------------------------------------------------------
void TestBuildAndLinkLibrary::TestParseBFF() const
{
	FBuildOptions options;
	options.m_ConfigFile = "Data/TestBuildAndLinkLibrary/fbuild.bff";

	FBuild fBuild( options );
	TEST_ASSERT( fBuild.Initialize() );
}

// TestBuildLib
//------------------------------------------------------------------------------
void TestBuildAndLinkLibrary::TestBuildLib() const
{
	FBuildOptions options;
	options.m_ConfigFile = "Data/TestBuildAndLinkLibrary/fbuild.bff";

	FBuild fBuild( options );
	fBuild.Initialize();

	const AStackString<> lib( "../../../../ftmp/Test/BuildAndLinkLibrary/test.lib" );
	const AStackString<> obj1( "../../../../ftmp/Test/BuildAndLinkLibrary/a.obj" );
	const AStackString<> obj2( "../../../../ftmp/Test/BuildAndLinkLibrary/b.obj" );
	const AStackString<> obj3( "../../../../ftmp/Test/BuildAndLinkLibrary/c.obj" );

	// clean up anything left over from previous runs
	FileIO::FileDelete( lib.Get() );
	FileIO::FileDelete( obj1.Get() );
	FileIO::FileDelete( obj2.Get() );
	FileIO::FileDelete( obj3.Get() );
	TEST_ASSERT( FileIO::FileExists( lib.Get() ) == false );
	TEST_ASSERT( FileIO::FileExists( obj1.Get() ) == false );
	TEST_ASSERT( FileIO::FileExists( obj2.Get() ) == false );
	TEST_ASSERT( FileIO::FileExists( obj3.Get() ) == false );

	TEST_ASSERT( fBuild.Build( lib ) );

	// make sure all output files are as expecter
	TEST_ASSERT( FileIO::FileExists( lib.Get() ) );
	TEST_ASSERT( FileIO::FileExists( obj1.Get() ) );
	TEST_ASSERT( FileIO::FileExists( obj2.Get() ) );
	TEST_ASSERT( FileIO::FileExists( obj3.Get() ) );
}

//------------------------------------------------------------------------------
