// Job - a work item to be processed
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_WORKERPOOL_JOB_H
#define FBUILD_WORKERPOOL_JOB_H

// Includes
//------------------------------------------------------------------------------
#include <Core/Env/Types.h>

// Forward Declarations
//------------------------------------------------------------------------------
class IOStream;
class Node;

// Job
//------------------------------------------------------------------------------
class Job
{
public:
	explicit Job( Node * node );
	explicit Job( IOStream & stream );
			~Job();

	inline uint32_t GetJobId() const { return m_JobId; }
	inline bool operator == ( uint32_t jobId ) const { return ( m_JobId == jobId ); }

	inline Node * GetNode() const { return m_Node; }

	// associate some data with this object, and destroy it when freed
	void	OwnData( void * data, size_t size, bool compressed = false );

	inline void *	GetData() const		{ return m_Data; }
	inline size_t	GetDataSize() const { return m_DataSize; }

	inline void		SetUserData( void * data )	{ m_UserData = data; }
	inline void *	GetUserData() const			{ return m_UserData; }

	inline bool		IsDataCompressed() const { return m_DataIsCompressed; }
	inline bool		IsLocal() const		{ return m_IsLocal; }

	// serialization for remote distribution
	void Serialize( IOStream & stream );
	void Deserialize( IOStream & stream );

private:
	uint32_t m_JobId;
	Node * m_Node;
	void * m_Data;
	uint32_t m_DataSize;
	void * m_UserData;
	bool m_DataIsCompressed;
	bool m_IsLocal;
};

//------------------------------------------------------------------------------
#endif // FBUILD_WORKERPOOL_JOB_H 