// Protocol.h - Defines network communication protocol
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_PROTOCOL_PROTOCOL_H
#define FBUILD_PROTOCOL_PROTOCOL_H

// Includes
//------------------------------------------------------------------------------
#include <Core/Env/Types.h>

// Forward Declarations
//------------------------------------------------------------------------------
class ConnectionInfo;
class MemoryStream;
class TCPConnectionPool;

// Protocol
//------------------------------------------------------------------------------
namespace Protocol
{
	enum { PROTOCOL_PORT = 31264 };	// Arbitrarily chosen port
	enum { PROTOCOL_VERSION = 1 };

	// Identifiers for all unique messages
	//------------------------------------------------------------------------------
	enum MessageType
	{
		MSG_CONNECTION			= 1,
		MSG_STATUS				= 2,
		MSG_REQUEST_JOB			= 3,
		MSG_NO_JOB_AVAILABLE	= 4,
		MSG_JOB					= 5,
		MSG_JOB_RESULT			= 6,
	};

	// base class for all messages
	//------------------------------------------------------------------------------
	class IMessage
	{
	public:
		void Send( const ConnectionInfo * connection ) const;
		void Broadcast( TCPConnectionPool * pool ) const;

		inline MessageType	GetType() const { return m_MsgType; }
		inline bool			HasPayload() const { return m_HasPayload; }

	protected:
		IMessage( MessageType msgType, uint32_t msgSize, bool hasPayload );

		// properties common to all messages
		MessageType		m_MsgType;
		uint32_t		m_MsgSize;
		bool			m_HasPayload;
	};

	// MsgConnection
	//------------------------------------------------------------------------------
	class MsgConnection : public IMessage
	{
	public:
		MsgConnection();

		inline uint32_t GetProtocolVersion() const { return m_ProtocolVersion; }
	private:
		uint32_t		m_ProtocolVersion;
	};

	// MsgStatus
	//------------------------------------------------------------------------------
	class MsgStatus : public IMessage
	{
	public:
		MsgStatus( uint32_t numJobsAvailable );

		inline uint32_t GetNumJobsAvailable() const { return m_NumJobsAvailable; }
	private:
		uint32_t		m_NumJobsAvailable;
	};

	// MsgRequestJob
	//------------------------------------------------------------------------------
	class MsgRequestJob : public IMessage
	{
	public:
		MsgRequestJob();
	};

	// MsgNoJobAvailable
	//------------------------------------------------------------------------------
	class MsgNoJobAvailable : public IMessage
	{
	public:
		MsgNoJobAvailable();
	};

	// MsgJob
	//------------------------------------------------------------------------------
	class MsgJob : public IMessage
	{
	public:
		MsgJob();
		void Send( const ConnectionInfo * ci, const MemoryStream & ms ) const;
	};

	// MsgJobResult
	//------------------------------------------------------------------------------
	class MsgJobResult : public IMessage
	{
	public:
		MsgJobResult();
		void Send( const ConnectionInfo * ci, const MemoryStream & ms ) const;
	};
};

//------------------------------------------------------------------------------
#endif // FBUILD_PROTOCOL_PROTOCOL_H
