// FBuildStats - Repository for build statistics.
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_HELPERS_FBUILDSTATS_H
#define FBUILD_HELPERS_FBUILDSTATS_H

// Includes
//------------------------------------------------------------------------------
#include <Core/Env/Types.h>
#include <Tools/FBuild/FBuildCore/Graph/Node.h>

// FBuildStats
//------------------------------------------------------------------------------
struct FBuildStats
{
public:
	FBuildStats();

	// statistics updated from the main thread

	// node/object counts
	uint32_t	m_NumNodesInTarget;		// Number of nodes in target graph

	// time estimation/progress
	uint32_t	m_NodeTimeTotalms;
	uint32_t	m_NodeTimeProgressms;

	// total time spent
	float		m_TotalBuildTime;		// Total time taken

	// after the build it complete, accumulate all the stats
	void GatherPostBuildStatistics( Node * node );

	void OutputSummary() const;

	// get the total stats
	uint32_t GetNodesProcessed() const	{ return m_Totals.m_NumProcessed; }
	uint32_t GetNodesBuilt() const		{ return m_Totals.m_NumBuilt; }
	uint32_t GetCacheHits() const		{ return m_Totals.m_NumCacheHits; }
	uint32_t GetCacheMisses() const		{ return m_Totals.m_NumCacheMisses; }
	uint32_t GetCacheStores() const		{ return m_Totals.m_NumCacheStores; }

private:
	void GatherPostBuildStatisticsRecurse( Node * node );

	void FormatTime( float timeInSeconds , AString & buffer ) const;

	uint32_t m_TotalLocalCPUTimeMS;

	Array< Node * > m_MostExpensiveNodes;
	uint32_t m_LowestTimeOfExpensiveNodes;

	// track these stats for each node type
	struct Stats
	{
		Stats();

		uint32_t m_NumProcessed;
		uint32_t m_NumBuilt;
		uint32_t m_NumCacheHits;
		uint32_t m_NumCacheMisses;
		uint32_t m_NumCacheStores;
	};
	Stats m_PerTypeStats[ Node::NUM_NODE_TYPES ];
	Stats m_Totals;
};

//------------------------------------------------------------------------------
#endif // FBUILD_HELPERS_FBUILDSTATS_H 