// CIncludeParser - Parse a c, cpp or h file and return all included headers
//                  recursively.
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_HELPERS_CINCLUDEPARSER_H
#define FBUILD_HELPERS_CINCLUDEPARSER_H

// Includes
//------------------------------------------------------------------------------
#include <Core/Containers/Array.h>
#include <Core/Strings/AString.h>

// CIncludeParser class
//------------------------------------------------------------------------------
class CIncludeParser
{
public:
	explicit CIncludeParser();
	~CIncludeParser();

	bool ParseMSCL_Output( const char * compilerOutput, size_t compilerOutputSize );
	bool ParseMSCL_Preprocessed( const char * compilerOutput, size_t compilerOutputSize );
	bool ParseGCC_Preprocessed( const char * compilerOutput, size_t compilerOutputSize );

	const Array< AString > & GetIncludes() const { return m_Includes; }

private:
	bool Parse( const char * compilerOutput,
				size_t compilerOutputSize,
				const char * startOfLineString,
				bool quoted );

	Array< AString > m_Includes;
};

//------------------------------------------------------------------------------
#endif // FBUILD_HELPERS_CINCLUDEPARSER_H 