// UnityNode.h - a node that builds a unity.cpp file
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_GRAPH_UNITYNODE_H
#define FBUILD_GRAPH_UNITYNODE_H

// Includes
//------------------------------------------------------------------------------
#include "FileNode.h"
#include <Core/Containers/Array.h>

// Forward Declarations
//------------------------------------------------------------------------------
class DirectoryListNode;

// UnityNode
//------------------------------------------------------------------------------
class UnityNode : public Node
{
public:
	explicit UnityNode( const AString & unityName,
						const Array< DirectoryListNode * > & dirNodes,
						const AString & outputPath,
						const AString & outputPattern,
						uint32_t numUnityFilesToCreate,
						const AString & precompiledHeader,
						const Array< AString > & filesToExclude );
	virtual ~UnityNode();

	static inline Node::Type GetType() { return Node::UNITY_NODE; }

	inline const Array< AString > & GetUnityFileNames() const { return m_UnityFileNames; }

	static Node * Load( IOStream & stream, bool remote );
	virtual bool Save( IOStream & stream ) const;
private:
	virtual const Array< Node * > & GetStaticDependencies() const;
	virtual bool DetermineNeedToBuild( bool forceClean );
	virtual BuildResult DoBuild( Job * job );

	virtual bool IsAFile() const { return false; }

	Array< Node * > m_StaticDependencies;
	AString m_OutputPath;
	AString m_OutputPattern;
	uint32_t m_NumUnityFilesToCreate;
	Array< AString > m_UnityFileNames;
	AString m_PrecompiledHeader;
	Array< AString > m_FilesToExclude;
};

//------------------------------------------------------------------------------
#endif // FBUILD_GRAPH_LIBRARYNODE_H
