// LinkerNode.h - builds an exe or dll
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_GRAPH_LINKERNODE_H
#define FBUILD_GRAPH_LINKERNODE_H

// Includes
//------------------------------------------------------------------------------
#include "FileNode.h"
#include <Core/Containers/Array.h>

// Forward Declarations
//------------------------------------------------------------------------------

// LinkerNode
//------------------------------------------------------------------------------
class LinkerNode : public FileNode
{
public:
	explicit LinkerNode( const AString & linkerOutputName,
						 const Array< Node * > & inputLibraries,
						 const AString & linker,
						 const AString & linkerArgs );
	virtual ~LinkerNode();

	static inline Node::Type GetType() { return Node::LINKER_NODE; }

	static Node * Load( IOStream & stream, bool remote );
	virtual bool Save( IOStream & stream ) const;
private:
	virtual const Array< Node * > & GetStaticDependencies() const;
	virtual bool DetermineNeedToBuild( bool forceClean );
	virtual BuildResult DoBuild( Job * job );

	Array< Node * > m_StaticDependencies;

	AString m_Linker;
	AString m_LinkerArgs;
};

//------------------------------------------------------------------------------
#endif // FBUILD_GRAPH_LINKERNODE_H
