// LibraryNode.h - a node that builds a single object from a source file
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_GRAPH_LIBRARYNODE_H
#define FBUILD_GRAPH_LIBRARYNODE_H

// Includes
//------------------------------------------------------------------------------
#include "FileNode.h"
#include <Core/Containers/Array.h>

// Forward Declarations
//------------------------------------------------------------------------------
class ObjectNode;

// LibraryNode
//------------------------------------------------------------------------------
class LibraryNode : public FileNode
{
public:
	explicit LibraryNode( const AString & libraryName,
						  Array< Node * > & inputNodes,
						  FileNode * compiler,
						  const AString & compilerArgs,
						  const AString & compilerOutputPath,
						  const AString & linker,
						  const AString & linkerArgs,
						  ObjectNode * precompiledHeader );
	virtual ~LibraryNode();

	static inline Node::Type GetType() { return Node::LIBRARY_NODE; }

	static Node * Load( IOStream & stream, bool remote );
	virtual bool Save( IOStream & stream ) const;
private:
	virtual const Array< Node * > & GetStaticDependencies() const;
	virtual const Array< Node * > & GetDynamicDependencies() const;
	virtual bool DoDynamicDependencies( bool forceClean );
	virtual bool DetermineNeedToBuild( bool forceClean );
	virtual BuildResult DoBuild( Job * job );

	// internal helpers
	bool CreateDynamicObjectNode( Node * inputFile );

	Array< Node * > m_StaticDependencies;
	Array< Node * > m_DynamicDependencies;
	FileNode * m_Compiler;
	AString m_CompilerArgs;
	AString m_CompilerOutputPath;
	AString m_LinkerPath;
	AString m_LinkerArgs;
	ObjectNode * m_PrecompiledHeader;
};

//------------------------------------------------------------------------------
#endif // FBUILD_GRAPH_LIBRARYNODE_H
