// FileNode.h - a node that tracks a single file
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_GRAPH_FILENODE_H
#define FBUILD_GRAPH_FILENODE_H

// Includes
//------------------------------------------------------------------------------
#include "Node.h"

// FileNode
//------------------------------------------------------------------------------
class FileNode : public Node
{
public:
	explicit FileNode( const AString & fileName, uint32_t controlFlags = Node::FLAG_TRIVIAL_BUILD );
	virtual ~FileNode();

	inline uint64_t GetTimeStamp() const { return m_TimeStamp; }

	static inline Node::Type GetType() { return Node::FILE_NODE; }

	virtual bool IsAFile() const { return true; }

	static Node * Load( IOStream & stream, bool remote );
	virtual bool Save( IOStream & stream ) const;
protected:
	virtual bool DetermineNeedToBuild( bool forceClean );
	virtual BuildResult DoBuild( Job * job );

	friend class Client;
	uint64_t m_TimeStamp;
};

//------------------------------------------------------------------------------
#endif // FBUILD_GRAPH_FILENODE_H
