// FileNode.cpp
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "FileNode.h"
#include <Tools/FBuild/FBuildCore/FBuild.h>
#include <Tools/FBuild/FBuildCore/FLog.h>
#include <Tools/FBuild/FBuildCore/Graph/NodeGraph.h>

#include <Core/FileIO/FileIO.h>
#include <Core/FileIO/FileStream.h>
#include <Core/Strings/AStackString.h>

#include <windows.h>

// CONSTRUCTOR
//------------------------------------------------------------------------------
FileNode::FileNode( const AString & fileName, uint32_t controlFlags )
: Node( fileName, Node::FILE_NODE, controlFlags )
{
	ASSERT( fileName.EndsWith( "\\" ) == false );
	ASSERT( ( fileName.FindLast( ':' ) == nullptr ) ||
			( fileName.FindLast( ':' ) == ( fileName.Get() + 1 ) ) );

	m_TimeStamp = 0;
	m_LastBuildTimeMs = 1; // very little work required
}

// DESTRUCTOR
//------------------------------------------------------------------------------
FileNode::~FileNode()
{
}

// DetermineNeedToBuild
//------------------------------------------------------------------------------
/*virtual*/ bool FileNode::DetermineNeedToBuild( bool forceClean )
{
	(void)forceClean; // not applicable to FileNode

	// FileNode never needs building, we do all the work we need right here
	// however.....
	m_TimeStamp = FileIO::GetFileLastWriteTime( m_Name );

	// NOTE: Even if the file is missing, that's not a failure, as this can
	// occur as follows:
	// - A includes B
	// - compile, storing above dependency
	// - B is deleted and simultaneously include of it is removed from A
	// - compile, and check if B has changed finds no file because dep is stale
	// In the case where the file is deleted, but still needed, the compilation
	// will fail, but we want the compiler to emit the error (line number etc)
	// so that's still desireable

	return false; // we never need the build step
}

// DoBuild
//------------------------------------------------------------------------------
/*virtual*/ Node::BuildResult FileNode::DoBuild( Job * UNUSED( job ) )
{
	ASSERT( false ); // should never get here
	return NODE_RESULT_FAILED;
}

// Load
//------------------------------------------------------------------------------
/*static*/ Node * FileNode::Load( IOStream & stream, bool remote )
{
	NODE_LOAD( AStackString<>,	fileName );

	NodeGraph & ng = FBuild::Get().GetDependencyGraph();
	Node * n = ng.CreateFileNode( fileName );
	ASSERT( n );
	return n;
}

// Save
//------------------------------------------------------------------------------
/*virtual*/ bool FileNode::Save( IOStream & stream ) const
{
	NODE_SAVE( m_Name );
	return true;
}

//------------------------------------------------------------------------------
