// ExecNode
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_GRAPH_EXECNODE_H
#define FBUILD_GRAPH_EXECNODE_H

// Includes
//------------------------------------------------------------------------------
#include "FileNode.h"
#include <Core/Containers/Array.h>

// Forward Declarations
//------------------------------------------------------------------------------

// ExecNode
//------------------------------------------------------------------------------
class ExecNode : public FileNode
{
public:
	explicit ExecNode( const AString & dstFileName,
					    FileNode * sourceFile,
						FileNode * executable,
						const char * arguments,
						const char * workingDir );
	virtual ~ExecNode();

	static inline Node::Type GetType() { return Node::EXEC_NODE; }

	static Node * Load( IOStream & stream, bool remote );
	virtual bool Save( IOStream & stream ) const;
private:
	virtual const Array< Node * > & GetStaticDependencies() const;
	virtual bool DetermineNeedToBuild( bool forceClean );
	virtual BuildResult DoBuild( Job * job );

	Array< Node * > m_StaticDependencies;
	FileNode * m_SourceFile;
	FileNode * m_Executable;
	AString		m_Arguments;
	AString		m_WorkingDir;
};

//------------------------------------------------------------------------------
#endif // FBUILD_GRAPH_EXECNODE_H
