// CopyNode.h - a node that copies a single object
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_GRAPH_COPYNODE_H
#define FBUILD_GRAPH_COPYNODE_H

// Includes
//------------------------------------------------------------------------------
#include "FileNode.h"

// Forward Declarations
//------------------------------------------------------------------------------

// CopyNode
//------------------------------------------------------------------------------
class CopyNode : public FileNode
{
public:
	explicit CopyNode( const AString & dstFileName,
					    FileNode * sourceFile );
	virtual ~CopyNode();

	static inline Node::Type GetType() { return Node::COPY_NODE; }

	static Node * Load( IOStream & stream, bool remote );
	virtual bool Save( IOStream & stream ) const;

private:
	virtual const Array< Node * > & GetStaticDependencies() const;
	virtual bool DetermineNeedToBuild( bool forceClean );
	virtual BuildResult DoBuild( Job * job );

	FileNode * m_SourceFile;
	Array< Node * > m_StaticDependencies;
};

//------------------------------------------------------------------------------
#endif // FBUILD_GRAPH_COPYNODE_H
