// CSNode.h - a node that builds a C# assembly
//------------------------------------------------------------------------------
#pragma once
#ifndef FBUILD_GRAPH_CSNODE_H
#define FBUILD_GRAPH_CSNODE_H

// Includes
//------------------------------------------------------------------------------
#include "FileNode.h"
#include <Core/Containers/Array.h>

// Forward Declarations
//------------------------------------------------------------------------------

// CSNode
//------------------------------------------------------------------------------
class CSNode : public FileNode
{
public:
	explicit CSNode( const AString & compilerOutput,
					 const Array< Node * > & inputNodes,
					 const AString & compiler,
					 const AString & compilerArgs,
					 const Array< Node * > & extraRefs );
	virtual ~CSNode();

	static inline Node::Type GetType() { return Node::CS_NODE; }

	virtual const Array< Node * > & GetStaticDependencies() const;
	virtual const Array< Node * > & GetDynamicDependencies() const;

	virtual bool Save( IOStream & stream ) const;
	static Node * Load( IOStream & stream, bool remote );
private:
	virtual bool DoDynamicDependencies( bool forceClean );
	virtual bool DetermineNeedToBuild( bool forceClean );
	virtual BuildResult DoBuild( Job * job );

	void EmitCompilationMessage( const AString & fullArgs ) const;
	
	Array< Node * > m_StaticDependencies;
	Array< Node * > m_DynamicDependencies;

	AString m_CompilerPath;
	AString m_CompilerArgs;

	Array< Node * > m_ExtraRefs;
};

//------------------------------------------------------------------------------
#endif // FBUILD_GRAPH_CSNODE_H
