// FunctionTest
//------------------------------------------------------------------------------

// Includes
//------------------------------------------------------------------------------
#include "FunctionTest.h"
#include <Tools/FBuild/FBuildCore/FBuild.h>
#include <Tools/FBuild/FBuildCore/BFF/BFFVariable.h>
#include <Tools/FBuild/FBuildCore/Graph/NodeGraph.h>
#include <Tools/FBuild/FBuildCore/Graph/TestNode.h>

// CONSTRUCTOR
//------------------------------------------------------------------------------
FunctionTest::FunctionTest()
: Function( "Test" )
{
}

// AcceptsHeader
//------------------------------------------------------------------------------
/*virtual*/ bool FunctionTest::AcceptsHeader() const
{
	return true;
}

// Commit
//------------------------------------------------------------------------------
/*virtual*/ bool FunctionTest::Commit( const BFFIterator & funcStartIter ) const
{
	// make sure all required variables are defined
	const BFFVariable * outputV;
	const BFFVariable * executableV;
	const BFFVariable * argsV;
	const BFFVariable * workingDirV;
	if ( !GetString( funcStartIter, outputV,		".TestOutput", true ) ||
		 !GetString( funcStartIter, executableV,	".TestExecutable", true ) ||
		 !GetString( funcStartIter, argsV,			".TestArguments" ) ||
		 !GetString( funcStartIter, workingDirV,	".TestWorkingDir" ) )
	{
		return false;
	}

	// check for duplicates
	NodeGraph & ng = FBuild::Get().GetDependencyGraph();
	if ( ng.FindNode( outputV->GetValue() ) != nullptr )
	{
		Error::Error_1100_AlreadyDefined( funcStartIter, this, outputV->GetValue() );
		return false;
	}

	Node * testExeNode = ng.FindNode( executableV->GetValue() );
	if ( testExeNode == nullptr )
	{
		Error::Error_1104_TargetNotDefined( funcStartIter, this, "TestExecutable", executableV->GetValue() );
		return false;
	}
	if ( testExeNode->IsAFile() == false )
	{
		Error::Error_1103_NotAFile( funcStartIter, this, "TestExecutable", testExeNode->GetName(), testExeNode->GetType() );
		return false;
	}

	// optional args
	const AString & arguments(	argsV ?			argsV->GetValue()		: AString::GetEmpty() );
	const AString & workingDir( workingDirV ?	workingDirV->GetValue() : AString::GetEmpty() );

	// create the TestNode
	Node * outputNode = ng.CreateTestNode( outputV->GetValue(), 
										   (FileNode *)testExeNode,
										   arguments,
										   workingDir );
	
	return ProcessAlias( funcStartIter, outputNode );
}

//------------------------------------------------------------------------------
